<?php

class EWRporta_ViewPublic_Portal extends XenForo_ViewPublic_Base
{
	public function renderHtml()
	{
		$visitor = XenForo_Visitor::getInstance();
		$cacheModel = new EWRporta_Model_Cache;
		$modulesModel = new EWRporta_Model_Modules;
		$settingsModel = new EWRporta_Model_Settings;

		$caches = $cacheModel->getCaches();
		$modules = $modulesModel->getModules();
		$settings = $settingsModel->getSettings();
		$blocks = array('top' => array(), 'bottom' => array(), 'left' => array(), 'center' => array(), 'right' => array());

		foreach ($modules AS $module)
		{
			if ($module['module_position'] == 'disabled') { continue; }

			if (!empty($module['module_show']))
			{
				$groups = explode(',', $module['module_show']);

				foreach ($groups AS $group)
				{
					if ($visitor->isMemberOf($group)) { $show = true; break; }
				}

				if (empty($show)) { continue; }
			}

			if (!empty($module['module_hide']))
			{
				$groups = explode(',', $module['module_hide']);

				foreach ($groups AS $group)
				{
					if ($visitor->isMemberOf($group)) { $hide = true; continue 2; }
				}
			}

			$module['cache'] = !empty($caches[$module['module_name']]) ? $caches[$module['module_name']] : false;
			$module['settings'] = !empty($settings[$module['module_name']]) ? $settings[$module['module_name']] : false;

			$params = $this->getModuleParams($module, $this->_params['page']);
			if (!empty($params[$module['module_name']]) && $params[$module['module_name']] == 'killModule') { continue; }

			if (!empty($params['option']['parseBB']))
			{
				$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create('Base', array('view' => $this)));
				$bbCodeOptions = array('states' => array('viewAttachments' => true));
				XenForo_ViewPublic_Helper_Message::bbCodeWrapMessages($params[$module['module_name']], $bbCodeParser, $bbCodeOptions);
			}

			$object = $this->createTemplateObject('EWRporta_Block_'.$module['module_name'], $params);

			switch ($module['module_position'])
			{
				case "top":			$blocks['top'][] = $object;			break;
				case "bottom":		$blocks['bottom'][] = $object;		break;
				case "left":		$blocks['left'][] = $object;		break;
				case "center":		$blocks['center'][] = $object;		break;
				case "right":		$blocks['right'][] = $object;		break;
			}
		}

		$this->_params['blocks'] = $blocks;
	}

	public function getModuleParams($module, $page, $params = array())
	{
		$template = 'EWRporta_Block_'.$module['module_name'];
		$params['position'] = $module['module_position'];

		if ($module['module_name'] == 'RecentNews' && $page > 1)
		{
			$params['option'] = $module['settings'];
			$params['page'] = $page;

			$model = new $template;
			$params[$module['module_name']] = $model->getModule($params['option'], $this->_params['page']);

			return $params;
		}

		if (strtotime($module['module_cache'], $module['cache']['module_date']) < XenForo_Application::$time)
		{
			$params['option'] = $module['settings'];

			if (XenForo_Application::autoload($template))
			{
				$model = new $template;

				if (method_exists($model, 'getModule'))
				{
					$params[$module['module_name']] = $model->getModule($params['option'], $this->_params['page']);
					if ($params[$module['module_name']] == 'killModule') { return $params; }
				}
			}

			if ($module['module_cache'] != 'now')
			{
				$cacheModel = new EWRporta_Model_Cache;
				$cacheModel->buildModuleCache($module, serialize($params));
			}

			if (isset($model))
			{
				if (method_exists($model, 'getBypass'))
				{
					$params[$module['module_name']] = $model->getBypass($params);
				}
			}
		}
		else
		{
			$params = unserialize($module['cache']['module_settings']);

			if (XenForo_Application::autoload($template))
			{
				$model = new $template;

				if (method_exists($model, 'getBypass'))
				{
					$params[$module['module_name']] = $model->getBypass($params);
				}
			}

		}

		return $params;
	}
}